/*
	Description:
		* Nintendo Mod MySql Save Includes

	Written By Soloist, updated by Mephisto
	Version 1.6
	Last Updated On 22/08/09

	*************************************************************************************

	Changelog
		Version 1.6
			* excluded cvar registers
		Version 1.5
			* Fixed MySql bug
		Version 1.1
			* Fixed sql bug with players have a ' in there name
			* Fixed sql not loading
		Version 1.0
			* Release of the plugin
*/

#include <dbi>

public Saving_Init()
{
	new Sql:sql
	if (!DBConnect(sql))
	{
		log_amx("[Nintendo Mod] ***********************************************************************");
		log_amx("[Nintendo Mod] * Failed connecting to database! Check your settings. Pausing plugin. *");
		log_amx("[Nintendo Mod] ***********************************************************************");
		pause("a");
	}
	else
	{
		log_amx("[Nintendo Mod] Connected successfully to SQL database.");
		dbi_close(sql);
	}
}

stock DBConnect(&Sql:sql)
{
	new host[128], user[128], pass[128], db[128], error[128];
	get_cvar_string("nm_mysql_host", host, 127);
	get_cvar_string("nm_mysql_user", user, 127);
	get_cvar_string("nm_mysql_pass", pass, 127);
	get_cvar_string("nm_mysql_db", db, 127);
	sql = dbi_connect(host, user, pass, db, error, 127);
	if(sql == SQL_FAILED)
	{
		log_amx("[Nintendo Mod] Can't connect to SQL DB");
		return false;
	}
	else
	{
		new query[1024], Result:result;
		format(query, 1023, "CREATE TABLE IF NOT EXISTS nm_users (steamid varchar(35) NOT NULL, playername varchar(35) NOT NULL, charname varchar(35) NOT NULL, level tinyint(4) NOT NULL, xp int(11) NOT NULL, skill1 tinyint(4) NOT NULL, skill2 tinyint(4) NOT NULL, skill3 tinyint(4) NOT NULL, powerup tinyint(4) NOT NULL, time timestamp(14) NOT NULL, PRIMARY KEY (steamid, charname)) COMMENT='Nintendo Mod';");
		result = dbi_query(sql, query);
		if(result == RESULT_FAILED)
		{
			dbi_error(sql, error, 255);
			log_amx("[Nintendo Mod] ERROR - Could not create table: %s", error);
			return false;
		}
	}

	return true;
}

public SaveXP(id)
{
	if(!Nintendo_Active() || !is_user_connected(id) || PlayerChar[id] == CLASS_NONE)
		return PLUGIN_HANDLED;

	new Sql:sql, Result:result, query[1024], error[256];
	new authid[32], playername[32];

	if(!DBConnect(sql))
		return PLUGIN_CONTINUE;

	get_user_authid(id, authid, 31);
	get_user_name(id, playername, 31);
	replace_all(playername, 31, "'", " ");

	format(query, 1023, "SELECT steamid, charname FROM nm_users WHERE steamid = '%s' AND charname = '%s'", authid, AllChars[PlayerChar[id]]);
	result = dbi_query(sql, query);

	if(result == RESULT_FAILED)
	{
		dbi_error(sql, error, 255);
		log_amx("[Nintendo Mod] ERROR - SaveXP - RESULT_FAILED: %s", error);
	}
	else if (result == RESULT_NONE)
	{
		dbi_free_result(result);
		format(query, 1023, "INSERT INTO nm_users (steamid, playername, charname, level, xp, skill1, skill2, skill3, powerup) VALUES ('%s', '%s', '%s', '%d', '%d', '%d', '%d', '%d', '%d')", authid, playername, AllChars[PlayerChar[id]], PlayerLevel[id][PlayerChar[id]], PlayerXP[id][PlayerChar[id]], PlayerSkill1[id][PlayerChar[id]], PlayerSkill2[id][PlayerChar[id]], PlayerSkill3[id][PlayerChar[id]], PlayerPowerUp[id][PlayerChar[id]]);
		result = dbi_query(sql, query);

		if(result <= RESULT_FAILED)
		{
			dbi_error(sql, error, 255)
			log_amx("[Nintendo Mod] ERROR - SaveXP - RESULT_NONE: %s", error);
		}
	}
	else
	{
		dbi_free_result(result);
		format(query, 1023, "UPDATE nm_users SET playername = '%s', level = '%d', xp = '%d', skill1 = '%d', skill2 = '%d', skill3 = '%d', powerup = '%d' WHERE steamid = '%s' AND charname = '%s'", playername, PlayerLevel[id][PlayerChar[id]], PlayerXP[id][PlayerChar[id]], PlayerSkill1[id][PlayerChar[id]], PlayerSkill2[id][PlayerChar[id]], PlayerSkill3[id][PlayerChar[id]], PlayerPowerUp[id][PlayerChar[id]], authid, AllChars[PlayerChar[id]]);
		result = dbi_query(sql, query);

		if(result <= RESULT_FAILED)
		{
			dbi_error(sql, error, 255)
			log_amx("[Nintendo Mod] ERROR - SaveXP: %s", error);
		}
	}

	dbi_free_result(result);
	dbi_close(sql);

	return PLUGIN_CONTINUE;
}

public SaveXPAll(id)
{
	if(!Nintendo_Active() || !is_user_connected(id))
		return PLUGIN_HANDLED;

	new Sql:sql, Result:result, query[1024], error[256];
	new authid[32], playername[32];

	if(!DBConnect(sql))
		return PLUGIN_CONTINUE;

	get_user_authid(id, authid, 31);
	get_user_name(id, playername, 31);
	replace_all(playername, 31, "'", " ");

	// Save their classes
	for(new i = 1; i <= NumAllChars; i++)
	{
		if(PlayerXP[id][i] != 0)
		{
			format(query, 1023, "SELECT steamid, charname FROM nm_users WHERE steamid = '%s' AND charname = '%s'", authid, AllChars[i]);
			result = dbi_query(sql, query);

			if(result == RESULT_FAILED)
			{
				dbi_free_result(result);
				dbi_error(sql, error, 255);
				log_amx("[Nintendo Mod] ERROR - SaveXPAll - RESULT_FAILED: %s", error);
				continue;
			}
			else if (result == RESULT_NONE)
			{
				dbi_free_result(result);
				format(query, 1023, "INSERT INTO nm_users (steamid, playername, charname, level, xp, skill1, skill2, skill3, powerup) VALUES ('%s', '%s', '%s', '%d', '%d', '%d', '%d', '%d', '%d')", authid, playername, AllChars[i], PlayerLevel[id][i], PlayerXP[id][i], PlayerSkill1[id][i], PlayerSkill2[id][i], PlayerSkill3[id][i], PlayerPowerUp[id][i]);
				result = dbi_query(sql, query);

				if(result <= RESULT_FAILED)
				{
					dbi_error(sql, error, 255)
					log_amx("[Nintendo Mod] ERROR - SaveXPAll - RESULT_NONE: %s", error);
					continue;
				}
			}
			else
			{
				dbi_free_result(result);
				format(query, 1023, "UPDATE nm_users SET playername = '%s', level = '%d', xp = '%d', skill1 = '%d', skill2 = '%d', skill3 = '%d', powerup = '%d' WHERE steamid = '%s' AND charname = '%s'", playername, PlayerLevel[id][i], PlayerXP[id][i], PlayerSkill1[id][i], PlayerSkill2[id][i], PlayerSkill3[id][i], PlayerPowerUp[id][i], authid, AllChars[i]);
				result = dbi_query(sql, query);

				if(result <= RESULT_FAILED)
				{
					dbi_error(sql, error, 255)
					log_amx("[Nintendo Mod] ERROR - SaveXPAll: %s", error);
					continue;
				}
			}
		}
	}

	dbi_free_result(result);
	dbi_close(sql);

	return PLUGIN_CONTINUE;
}

public LoadXP(id)
{
	if(!Nintendo_Active() || !is_user_connected(id))
		return PLUGIN_HANDLED;

	new Sql:sql, Result:result, query[1024], error[256];
	new authid[32], playername[32];

	if(!DBConnect(sql))
		return PLUGIN_CONTINUE;

	get_user_authid(id, authid, 31);
	get_user_name(id, playername, 31);
	replace_all(playername, 31, "'", " ");

	new iXp, iLevel, iSkill1, iSkill2, iSkill3, iPowerUp;

	for(new i = 1; i <= NumAllChars; i++)
	{
		format(query, 1023, "SELECT steamid, charname FROM nm_users WHERE steamid = '%s' AND charname = '%s'", authid, AllChars[i]);
		result = dbi_query(sql, query);

		if(result == RESULT_FAILED)
		{
			dbi_error(sql, error, 255);
			log_amx("[Nintendo Mod] ERROR - LoadXP - RESULT_FAILED: %s", error);
			dbi_free_result(result);
			continue;
		}
		else if (result == RESULT_NONE)
		{
			iXp = 0;
			iLevel = 0;
			iSkill1 = 0;
			iSkill2 = 0;
			iSkill3 = 0;
			iPowerUp = 0;
		}
		else
		{
			dbi_free_result(result);

			format(query, 1023, "SELECT level, xp, skill1, skill2, skill3, powerup from nm_users where steamid = '%s' AND charname = '%s'", authid, AllChars[i]);
			result = dbi_query(sql, query);
			if(result <= RESULT_FAILED)
			{
				dbi_error(sql, error, 255)
				log_amx("[Nintendo Mod] ERROR - LoadXP: %s", error);
				continue;
			}

			if(dbi_num_fields(result) != 6)
				log_amx("[Nintendo Mod] ERROR - LoadXP: Not enough fields check your table");

			dbi_nextrow(result);

			iLevel = dbi_field(result, 1);
			iXp = dbi_field(result, 2);
			iSkill1 = dbi_field(result, 3);
			iSkill2 = dbi_field(result, 4);
			iSkill3 = dbi_field(result, 5);
			iPowerUp = dbi_field(result, 6);
		}

		PlayerXP[id][i] = iXp;
		PlayerLevel[id][i] = iLevel;
		PlayerSkill1[id][i] = iSkill1;
		PlayerSkill2[id][i] = iSkill2;
		PlayerSkill3[id][i] = iSkill3;
		PlayerPowerUp[id][i] = iPowerUp;

		dbi_free_result(result);
	}

	dbi_free_result(result);
	dbi_close(sql);

	return PLUGIN_CONTINUE;
}

public ResetXPAll(id)
{

	if(!Nintendo_Active() || !is_user_connected(id))
		return PLUGIN_HANDLED;

	new Sql:sql, Result:result, query[1024], error[256];
	new authid[32], playername[32];

	if(!DBConnect(sql))
		return PLUGIN_CONTINUE;

	get_user_authid(id, authid, 31);
	get_user_name(id, playername, 31);
	replace_all(playername, 31, "'", " ");

	for(new i = 1; i <= NumAllChars; i++)
	{
		format(query, 1023, "SELECT steamid, charname FROM nm_users WHERE steamid = '%s' AND charname = '%s'", authid, AllChars[i]);
		result = dbi_query(sql, query);

		if(result == RESULT_FAILED)
		{
			dbi_error(sql, error, 255);
			log_amx("[Nintendo Mod] ERROR - ResetXPAll - RESULT_FAILED: %s", error);
			continue;
		}
		else if (result == RESULT_NONE)
			continue;
		else
		{
			format(query, 1023, "DELETE FROM nm_users WHERE steamid = '%s' AND charname = '%s'", authid, AllChars[i]);
			result = dbi_query(sql, query);

			if(result <= RESULT_FAILED)
			{
				dbi_error(sql, error, 255)
				log_amx("[Nintendo Mod] ERROR - ResetXPAll: %s", error);
				continue;
			}
		}
	}

	dbi_free_result(result);
	dbi_close(sql);

	return PLUGIN_CONTINUE;
}
